/******************************************************************************
 * (C) Copyright 2000 by Agilent Technologies GmbH. All rights reserved.      *
 ******************************************************************************/

/* ---------------------------------------------------------------
 * File: xct.h 
 *       Prototypes for Completer-Target (CT) functions
 * -----------------------------------------------------------------*/

#ifndef XCT_H_INCLUDED
#define XCT_H_INCLUDED

#ifndef CLI
#define CLI
#endif

#include <xctdefs.h>

#ifdef __cplusplus
extern "C" {
#endif
  
/********************************************************************
  CT programming ****************************************************
 ********************************************************************/

CLI bx_errtype EXPORT BestXCTProg(           /* @ctprog */
  bx_handletype  handle
);

CLI bx_errtype EXPORT BestXCTRead(           /* @ctread */
  bx_handletype  handle,
  bx_int32 option
);

/********************************************************************
  CT generics ***************************************************
 *******************************************************************/

CLI bx_errtype EXPORT BestXCTGenSet(               /* @ctgenset */
  bx_handletype        handle,     
  bx_ctgentype          prop,                          
  bx_int32             val                           
);

CLI bx_errtype EXPORT BestXCTGenGet(           /* @ctgenget */
  bx_handletype        handle,
  bx_ctgentype          prop,                          
  bx_int32             *val                    /* #RETURN "0x%08lx" */
);

CLI bx_errtype EXPORT BestXCTGenDefaultSet(    /* @ctgendefset */
  bx_handletype        handle
);

CLI bx_errtype EXPORT BestXCTGenProg(          /* @ctgenprog */
  bx_handletype        handle
);

CLI bx_errtype EXPORT BestXCTGenRead(          /* @ctgenread */
  bx_handletype        handle
);

/********************************************************************
  CT behavior *******************************************************
 *******************************************************************/

CLI  bx_errtype EXPORT BestXCTBehMemInit(           /* @ctbehmeminit */
  bx_handletype handle
);

CLI  bx_errtype EXPORT BestXCTBehDefaultSet(        /* @ctbehdefset */
  bx_handletype handle,
  bx_int32 offset
);

CLI bx_errtype EXPORT BestXCTBehSet(                /* @ctbehset */
  bx_handletype handle,
  bx_int32 offset,
  bx_ctbehtype prop,                                    
  bx_int32 val                                          
);

CLI  bx_errtype EXPORT BestXCTBehGet(               /* @ctbehget */
  bx_handletype handle,
  bx_int32 offset,
  bx_ctbehtype prop,                                     
  bx_int32   *val                                   /* #RETURN "0x%08lx" */
);

CLI bx_errtype EXPORT BestXCTBehProg(               /* @ctbehprog */
  bx_handletype  handle
);

CLI bx_errtype EXPORT BestXCTBehRead(               /* @ctbehread */
  bx_handletype  handle,
  bx_int32 option
);

CLI bx_errtype EXPORT BestXCTBehCopyLine(     /* @ctbehcopyline */
  bx_handletype  handle,
  bx_int32 srcline,
  bx_int32 destline
);

/********************************************************************
  Target split conditions *******************************************
 *******************************************************************/

CLI  bx_errtype EXPORT BestXCTSplitCondDefaultSet(   /* @ctsplitconddefset */
  bx_handletype handle,
  bx_int32 dec
);

CLI bx_errtype EXPORT BestXCTSplitCondSet(            /* @ctsplitcondset */
  bx_handletype handle,
  bx_int32 dec,
  bx_ctsplittype prop,                     
  bx_int32 val       
);

CLI  bx_errtype EXPORT BestXCTSplitCondGet(           /* @ctsplitcondget */
  bx_handletype handle,
  bx_int32 dec,
  bx_ctsplittype prop,                                
  bx_int32   *val                                     /* #RETURN "0x%08lx" */
);

CLI bx_errtype EXPORT BestXCTSplitCondProg(           /* @ctsplitcondprog */
  bx_handletype  handle
);

CLI bx_errtype EXPORT BestXCTSplitCondRead(           /* @ctsplitcondread */
  bx_handletype  handle
);

#ifdef __cplusplus
}
#endif

#endif




